<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>

    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title lang="en">Výpis směrové integrity</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Výpis směrové integrity</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br />
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>

                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@name"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@description"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@file"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední revize:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">&#xa0; </th>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách,</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech,</xsl:if>
                                                pokud není definováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>

                                <table class="margin" width="95%">
                                    <xsl:for-each select="HorizontalAlignment">
                                        <tbody>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">
                                                    <br />Název trasy:&#xa0;
                                                </th>
                                                <td align="left" colspan="3" valign="bottom">
                                                    <xsl:value-of select="@name"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Popis trasy:&#xa0;</th>
                                                <td align="left" colspan="3">
                                                    <xsl:value-of select="@description"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Styl trasy:&#xa0;</th>
                                                <td align="left" colspan="3">
                                                    <xsl:value-of select="@style"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th lang="en" align="left" class="underline">Prvek</th>
                                                <th lang="en" align="left" class="underline">
                                                    Počáteční bod<br/>Typ
                                                </th>
                                                <th lang="en" align="right" class="underline">Staničení</th>
                                                <th lang="en" align="right" class="underline">
                                                    Začátek<br/>Y
                                                </th>
                                                <th lang="en" align="right" class="underline">
                                                    Začátek<br/>X
                                                </th>
                                                <th lang="en" align="right" class="underline">
                                                    Začátek<br/>Směr
                                                </th>
                                                <th lang="en" align="left" class="underline">
                                                    Koncový bod<br/>Typ
                                                </th>
                                                <th lang="en" align="right" class="underline">
                                                    Konec<br/>Y
                                                </th>
                                                <th lang="en" align="right" class="underline">
                                                    Konec<br/>X
                                                </th>
                                                <th lang="en" align="right" class="underline">
                                                    Konec<br/>Směr
                                                </th>
                                                <th lang="en" align="right" class="underline">
                                                    Délka
                                                </th>
                                                <th lang="en" align="right" class="underline">
                                                    Poloměr
                                                </th>
                                                <th lang="en" align="right" class="underline">
                                                    Y<br/>Rozdíl<br/>(Od koncového k dalšímu)
                                                </th>
                                                <th lang="en" align="right" class="underline">
                                                    X<br/>Rozdíl<br/>(Od koncového k dalšímu)
                                                </th>
                                                <th lang="en" align="right" class="underline">
                                                    Úhel<br/>Rozdíl<br/>(Od koncového k dalšímu)
                                                </th>
                                                <th lang="en" align="right" class="underline">
                                                    Poloměr<br/>Rozdíl<br/>(Od koncového k dalšímu)
                                                </th>
                                            </tr>
                                            <xsl:apply-templates select="//HorizontalLine | //HorizontalCircle | //HorizontalSpiral"/>
                                        </tbody>
                                    </xsl:for-each>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="HorizontalLine">
        <tr>
            <td align="left" lang="en">Přímá</td>
            <td align="left"><xsl:value-of select="cif:pointType(string(Start/@pointType))"/></td>
            <td align="right" style="white-space:nowrap">
                <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:directionFormat(number(@direction))" />
            </td>
           <td align="left"><xsl:value-of select="cif:pointType(string(End/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(End/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(End/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:directionFormat(number(@direction))" />
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td>
            <td align="right"> </td>

            <xsl:if test="position() != last()">
                <xsl:if test="following-sibling::*[1][name() = 'HorizontalLine']">
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(End/@northing - following-sibling::*[1]/Start/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(End/@easting - following-sibling::*[1]/Start/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(@direction - following-sibling::*[1]/@direction))" />
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(0.0))"/>
                    </td>
                </xsl:if>
                <xsl:if test="following-sibling::*[1][name() = 'HorizontalCircle']">
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(End/@northing - following-sibling::*[1]/Start/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(End/@easting - following-sibling::*[1]/Start/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(@direction - following-sibling::*[1]/@tangentialDirectionStart))" />
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(0.0))"/>
                    </td>
                </xsl:if>
                <xsl:if test="following-sibling::*[1][name() = 'HorizontalSpiral']">
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(End/@northing - following-sibling::*[1]/Start/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(End/@easting - following-sibling::*[1]/Start/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(@direction - following-sibling::*[1]/@tangentialDirectionStart))" />
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(0.0- following-sibling::*[1]/@startRadius))"/>
                    </td>
                </xsl:if>
            </xsl:if>
        </tr>
    </xsl:template>

    <xsl:template match="HorizontalCircle">
        <tr>
            <td align="left" lang="en">Oblouk</td>
            <td align="left"><xsl:value-of select="cif:pointType( string( Start/@pointType ))"/></td>
            <td align="right" style="white-space:nowrap">
                <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:directionFormat(number(@tangentialDirectionStart))" />
            </td>
            <td align="left"><xsl:value-of select="cif:pointType(string(End/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(End/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(End/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:directionFormat(number(@tangentialDirectionEnd))" />
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td>
            <xsl:choose>
                <xsl:when test="@rotationDirection = 'ccw'">
                    <td align="right">
                        -<xsl:value-of select="cif:distanceFormat(number(@radius))"/>
                    </td>
                </xsl:when>
                <xsl:otherwise>
                    <td align="right">
                        +<xsl:value-of select="cif:distanceFormat(number(@radius))"/>
                    </td>
                </xsl:otherwise>
            </xsl:choose>

            <xsl:if test="position() != last()">
                <xsl:if test="following-sibling::*[1][name() = 'HorizontalLine']">
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(End/@northing - following-sibling::*[1]/Start/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(End/@easting - following-sibling::*[1]/Start/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(@tangentialDirectionEnd - following-sibling::*[1]/@direction))" />
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(0.0))"/>
                    </td>
                </xsl:if>
                <xsl:if test="following-sibling::*[1][name() = 'HorizontalCircle']">
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(End/@northing - following-sibling::*[1]/Start/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(End/@easting - following-sibling::*[1]/Start/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(@tangentialDirectionEnd - following-sibling::*[1]/@tangentialDirectionStart))" />
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(0.0))"/>
                    </td>
                </xsl:if>
                <xsl:if test="following-sibling::*[1][name() = 'HorizontalSpiral']">
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(End/@northing - following-sibling::*[1]/Start/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(End/@easting - following-sibling::*[1]/Start/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(@tangentialDirectionEnd - following-sibling::*[1]/@tangentialDirectionStart))" />
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(@radius - following-sibling::*[1]/@startRadius))"/>
                    </td>
                </xsl:if>
            </xsl:if>
        </tr>
    </xsl:template>

    <xsl:template match="HorizontalSpiral">
        <tr>
            <td align="left">
                <xsl:value-of select="@type"/>
            </td>
            <td align="left">
                <xsl:value-of select="cif:pointType( string( Start/@pointType ))"/>
            </td>
            <td align="right" style="white-space:nowrap">
                <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:directionFormat(number(@tangentialDirectionStart))" />
            </td>
            <td align="left">
                <xsl:value-of select="cif:pointType(string(End/@pointType))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(End/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(End/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:directionFormat(number(@tangentialDirectionEnd))" />
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td>
            <td align="right"> </td>

            <xsl:if test="position() != last()">
                <xsl:if test="following-sibling::*[1][name() = 'HorizontalLine']">
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(End/@northing - following-sibling::*[1]/Start/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(End/@easting - following-sibling::*[1]/Start/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(@tangentialDirectionEnd - following-sibling::*[1]/@direction))" />
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(@endRadius - 0.0))"/>
                    </td>
                </xsl:if>
                <xsl:if test="following-sibling::*[1][name() = 'HorizontalCircle']">
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(End/@northing - following-sibling::*[1]/Start/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(End/@easting - following-sibling::*[1]/Start/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(@tangentialDirectionEnd - following-sibling::*[1]/@tangentialDirectionStart))" />
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(@endRadius - following-sibling::*[1]/@radius))"/>
                    </td>
                </xsl:if>
                <xsl:if test="following-sibling::*[1][name() = 'HorizontalSpiral']">
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(End/@northing - following-sibling::*[1]/Start/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(End/@easting - following-sibling::*[1]/Start/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(@tangentialDirectionEnd - following-sibling::*[1]/@tangentialDirectionStart))" />
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(@endRadius - following-sibling::*[1]/@startRadius))"/>
                    </td>
                </xsl:if>
            </xsl:if>
        </tr>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vybrat nejméně jeden Civil prvek směrové geometrie.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
